"use strict";
var __awaiter = (this && this.__awaiter) || function (thisArg, _arguments, P, generator) {
    return new (P || (P = Promise))(function (resolve, reject) {
        function fulfilled(value) { try { step(generator.next(value)); } catch (e) { reject(e); } }
        function rejected(value) { try { step(generator["throw"](value)); } catch (e) { reject(e); } }
        function step(result) { result.done ? resolve(result.value) : new P(function (resolve) { resolve(result.value); }).then(fulfilled, rejected); }
        step((generator = generator.apply(thisArg, _arguments || [])).next());
    });
};
Object.defineProperty(exports, "__esModule", { value: true });
const constants_1 = require("./constants");
const vscode = require("vscode");
function activateExtension() {
    return __awaiter(this, void 0, void 0, function* () {
        const extension = vscode.extensions.getExtension(constants_1.SERVER_CONNECTOR_EXTENSION_ID);
        if (!extension) {
            return undefined;
        }
        const api = yield extension.activate();
        return api;
    });
}
function retrieveUIExtension() {
    return __awaiter(this, void 0, void 0, function* () {
        const api = yield activateExtension();
        if (!api) {
            return {
                available: false,
                reason: 'extension-not-available'
            };
        }
        return {
            available: true,
            api: api
        };
    });
}
exports.retrieveUIExtension = retrieveUIExtension;
//# sourceMappingURL=helper.js.map