USE STAMM
GO

--- Kunden ---
--------------
IF EXISTS (SELECT name FROM sysobjects WHERE name = 'Kunden' AND type = 'U')
  DROP TABLE Kunden
GO
CREATE TABLE Kunden
(
   KundenNr            int  PRIMARY KEY
 , Sex                 TinyInt  --- 0 == n/a    1 == Mann   2 == Frau
 , Titel               varchar(15)
 , Vorname             varchar(30)   NULL
 , Nachname            varchar(30)   NULL
 , Strasse             varchar(40)   NULL
 , Plz                 varchar(10)   NULL
 , Ort                 varchar(40)   NULL
 , Telefon             varchar(30)   NULL
 , Fax                 varchar(30)   NULL
 , EMail               varchar(50)   NULL
 , Geburtstag          SmallDateTime NULL
 , AnspNachname        varchar(30)   NULL --- fuer Pfl. HIMI
 , AnspVorname         varchar(30)   NULL --- fuer Pfl. HIMI
 , AnspTelefon         varchar(30)   NULL --- fuer Pfl. HIMI
 , Bemerkung           varchar(200)  NULL
 , Last_Rezept         SmallDateTime NULL
 , IsAmLeben           bit           
 , AngelegtAm          DateTime      NULL
 , AngelegtVon         int           NULL
 , BearbeitetAm        DateTime      NULL
 , BearbeitetVon       int           NULL
 , ApothekenCardNr     bigint        NULL
 , IsHausApoModel      bit           
 , ZuzahlungBisJJJJMM  int           NULL --- Format JJJJMM
)
GO
CREATE UNIQUE INDEX Kunden_Idx0 ON Kunden (KundenNr)
GO


--- VersNr ---
IF EXISTS (SELECT name FROM sysobjects WHERE name = 'VersNr' AND type = 'U')
  DROP TABLE VersNr
GO
CREATE TABLE VersNr
(
   KundenNr         int
 , VersNr           varchar(12) 
 , KassenIK         int 
 , Datum_Ab         DateTime     NULL
 , Datum_Bis        DateTime     NULL
 , IsAktuell        bit        
)
GO
CREATE UNIQUE INDEX VersNr_Idx0 ON VersNr (KundenNr, VersNr, KassenIK)
GO


--- PflVersNr ---
IF EXISTS (SELECT name FROM sysobjects WHERE name = 'PflVersNr' AND type = 'U')
  DROP TABLE PflVersNr
GO
CREATE TABLE PflVersNr
(
   KundenNr         int
 , PflVersNr        varchar(12)   NULL
 , PflKassenIK      int           NULL
 , PflDatum_Ab      DateTime      NULL
 , PflDatum_Bis     DateTime      NULL
 , PflIsAktuell     bit        
)
GO
CREATE UNIQUE INDEX PflVersNr_Idx0 ON PflVersNr (KundenNr, PflVersNr, PflKassenIK)
GO


--- Kassen ---
IF EXISTS (SELECT name FROM sysobjects WHERE name = 'Kassen' AND type = 'U')
  DROP TABLE Kassen
GO
CREATE TABLE Kassen
(
   KassenIK         int PRIMARY KEY
 , InterneNr        int          NULL
 , KassenArt        int          NULL
 , KassenName1      varchar(100) NULL
 , KassenName2      varchar(100) NULL
 , KurzBez          varchar(3)   NULL
 , Strasse          varchar(100) NULL
 , Plz              varchar(10)  NULL
 , Ort              varchar(100) NULL
 , Telefon          varchar(30)  NULL
 , FAX              varchar(30)  NULL
 , eMail            varchar(50)  NULL
 , WebSeite         varchar(50)  NULL
 , Hotline          varchar(100) NULL
 , Bemerkung        varchar(200) NULL
)
GO


--- PflegeKassen ---
IF EXISTS (SELECT name FROM sysobjects WHERE name = 'PflegeKassen' AND type = 'U')
  DROP TABLE PflegeKassen
GO
CREATE TABLE PflegeKassen
(
   PflKassenIK      int PRIMARY KEY
 , PflInterneNr     int          NULL
 , PflKassenArt     int          NULL
 , PflKassenName1   varchar(100) NULL
 , PflKassenName2   varchar(100) NULL
 , PflKurzBez       varchar(3)   NULL
 , Strasse          varchar(100) NULL
 , Plz              varchar(10)  NULL
 , Ort              varchar(100) NULL
 , Telefon          varchar(30)  NULL
 , FAX              varchar(30)  NULL
 , eMail            varchar(50)  NULL
 , WebSeite         varchar(50)  NULL
 , Hotline          varchar(100) NULL
 , Bemerkung        varchar(200) NULL
)
GO



USE PLHIMI
GO

IF EXISTS (SELECT name FROM sysobjects WHERE name = 'HIMIAntragPos' AND type = 'U')
  DROP TABLE HIMIAntragPos
GO
CREATE TABLE HIMIAntragPos
(
   AntragNr       int            NULL
 , AntragDatum    SmallDateTime  NULL
 , ArtikelNr      varchar(18)    NULL
 , ArtikelNrExt   varchar(18)    NULL
 , AnzahlAntrag   int            NULL
 , EinheitAntrag  int            NULL
 , AnzahlErteilt  int            NULL
 , EinheitErteilt int            NULL
 , Anzahl         int            NULL
 , Einheit        int            NULL
 , PreisNetto     numeric(18, 2) NULL
 , PreisBrutto    numeric(18, 2) NULL
 , MengenEinheit  varchar(50)    NULL
 , IsPG51         bit            NULL
)
GO

IF EXISTS (SELECT name FROM sysobjects WHERE name = 'HIMILieferPos' AND type = 'U')
  DROP TABLE HIMILieferPos
GO
CREATE TABLE HIMILieferPos
(
   AntragNr       int            NULL
 , ArtikelNr      varchar(18)    NULL
 , ArtikelNrExt   varchar(18)    NULL
 , LieferDatum    smalldatetime  NULL
 , Anzahl         int            NULL
 , Einheit        int            NULL
 , PreisNetto     numeric(18, 2) NULL
 , PreisBrutto    numeric(18, 2) NULL
 , MengenEinheit  varchar(50)    NULL
 , Kassenanteil   numeric(18, 2) NULL
 , Eigenanteil    numeric(18, 2) NULL
 , ZuzahlungPG51  numeric(18, 2) NULL
 , IsPG51         bit            NULL
 , IsVerbucht     bit            NULL
)
GO


IF EXISTS (SELECT name FROM sysobjects WHERE name = 'Artikel' AND type = 'U')
  DROP TABLE Artikel
GO
CREATE TABLE Artikel
(
   ArtikelNr         varchar(18)    PRIMARY KEY
 , KurzBez           varchar(50)    NULL
 , LangText          varchar(50)    NULL
 , VerPreisNetto     numeric(18, 2) NULL
 , VerPreisBrutto    numeric(18, 2) NULL
 , VerPreiseinheit   int            NULL
 , VerMengeneinheit  varchar(10)    NULL
 , ApoPreisNetto     numeric(18, 2) NULL
 , ApoPreisBrutto    numeric(18, 2) NULL
 , ApoPreiseinheit   int            NULL
 , ApoMengeneinheit  varchar(10)    NULL
 , IsPG51            bit            NULL
)
GO


IF EXISTS (SELECT name FROM sysobjects WHERE name = 'Firmenstamm' AND type = 'U')
  DROP TABLE Firmenstamm
GO
CREATE TABLE Firmenstamm
(
   IK            int PRIMARY KEY
 , Inhaber       varchar(40)   NULL
 , ApoName       varchar(40)   NULL
 , Strasse       varchar(40)   NULL
 , Plz           varchar(10)   NULL
 , Ort           varchar(40)   NULL
 , Nation        varchar(3)    NULL
 , Bundesland    varchar(50)   NULL
 , Telefon       varchar(30)   NULL
 , FAX           varchar(30)   NULL
 , eMail         varchar(30)   NULL
 , PrivateKey    varchar(5000) NULL
 , PublicKey     varchar(5000) NULL
 , RZ            int           NULL
 , IsHauptApo    bit           NULL
 , HauptApoIK    int           NULL
 , IDF           int           NULL
 , KundenNr      int           NULL
 , AntragNr      int           NULL
)
GO


IF EXISTS (SELECT name FROM sysobjects WHERE name = 'HIMIAntragKopf' AND type = 'U')
  DROP TABLE HIMIAntragKopf
GO
CREATE TABLE HIMIAntragKopf
(
   AntragNr         int  PRIMARY KEY
 , KundenNr         int              NULL
 , VersNr           varchar(12)      NULL
 , KassenIK         int              NULL
 , IsVerbucht       bit              NULL
 , AntragDatum      SmallDateTime    NULL
 , VersorgungsMonat varchar(7)       NULL
 , ErteiltDatum     SmallDateTime    NULL
 , AngelegtAm       DateTime         NULL
 , AngelegtVon      int              NULL
 , BearbeitetAm     DateTime         NULL
 , BearbeitetVon    int              NULL
 , IsPGAntrag54     bit              NULL
 , PGErteilt54      tinyint          NULL
 , IsPGAntrag51     bit              NULL
 , PGErteilt51      tinyint          NULL
)
GO


INSERT INTO PLHIMI..ARTIKEL Values ('54.45.01.0001','Saugende Bettschutzeinlagen - Einmalgebrauch',NULL,18.10,21.54,50,'Stck',NULL,NULL,NULL,NULL,0)
INSERT INTO PLHIMI..ARTIKEL Values ('54.99.01.0001','Fingerlinge',NULL,4.74,5.64,100,'Stck',NULL,NULL,NULL,NULL,0)
INSERT INTO PLHIMI..ARTIKEL Values ('54.99.01.1001','Einmalhandschuhe',NULL,6.03,7.18,100,'Stck',NULL,NULL,NULL,NULL,0)
INSERT INTO PLHIMI..ARTIKEL Values ('54.99.01.2001','Mundschutz',NULL,6.03,7.18,50,'Stck',NULL,NULL,NULL,NULL,0)
INSERT INTO PLHIMI..ARTIKEL Values ('54.99.01.3001','Schutzschrzen - Einmalgebrauch',NULL,11.21,13.34,100,'Stck',NULL,NULL,NULL,NULL,0)
INSERT INTO PLHIMI..ARTIKEL Values ('54.99.01.3002','Schutzschrzen - wiederverwendbar',NULL,21.55,25.64,1,'Stck',NULL,NULL,NULL,NULL,0)
INSERT INTO PLHIMI..ARTIKEL Values ('54.99.02.0001','Hndedesinfektions- mittel',NULL,6.90,8.21,500,'ml',NULL,NULL,NULL,NULL,0)
INSERT INTO PLHIMI..ARTIKEL Values ('54.99.02.0002','Flchendesinfektions- mittel',NULL,5.17,6.15,500,'ml',NULL,NULL,NULL,NULL,0)
INSERT INTO PLHIMI..ARTIKEL Values ('51.40.01.4','Saugende Bettschutzeinlagen - wiederverwendbar',NULL,5.17,26.16,1,'Stck',NULL,NULL,NULL,NULL,1)
GO
